<?php
/*
* Checking the server's configuration for Quick.Cms.Ext
* All rights reserved
*/
error_reporting( E_ALL );
if( !strstr( $_SERVER['REQUEST_URI'], 'qtest.html' ) ){
  exit( 'Open this file using address <strong><a href="qtest.html">qtest.html</a></strong> not <strong>qtest.php</strong>' );
}

$sYourEmail = 'YOUR_EMAIL_HERE'; // mail functions are usually disabled on LOCALHOST servers. Test it on your online server.

$sValue = (float) phpversion( );
if( $sValue < '8.2' )
  $aErrors[] = 'Required PHP version is <u>8.2.0</u>, your version is '.phpversion( );
if( !extension_loaded( 'pdo_sqlite' ) )
  $aErrors[] = 'Required <u>PDO</u> library with <u>pdo_sqlite</u> extension is not available';
if( file_get_contents( 'http://opensolution.org' ) === false )
  $aErrors[] = 'Turn ON <u>allow_url_fopen</u> in PHP configuration (php.ini)';
if( isset( $sYourEmail ) && strstr( $sYourEmail, '@' ) ){
  mail( $sYourEmail, 'QTEST EMAIL', 'QTEST EMAIL' );
}
try {
  $oPdo = new PDO( 'sqlite::memory:' );
  $sPdoSQLiteVer = $oPdo->getAttribute( PDO::ATTR_SERVER_VERSION );
  if( substr( $sPdoSQLiteVer, 0, 5 ) !== '3.39.' )
    $aErrors[] = "There is some problem with SQLite PDO driver version - it should match v3.39.x but it is currently {$sPdoSQLiteVer}";
} catch (PDOException $e) {
  $aErrors[] = 'There is some problem with SQLite PDO driver';
}

if( isset( $aErrors ) ){
  echo '<h1>Found some problems:</h1><ul><li>'.implode( '</li><li>', $aErrors ).'</li></ul>';
}
else{
  echo '<h1>Congratulations! It seems that all works great</h1>'.( strstr( $sYourEmail, '@' ) ? '<h2>Sending email test</h2><p>Script has sent email to the email address you\'ve typed. Open your <strong>'.$sYourEmail.'</strong> mailbox and check ( also in the spam folder ) whether you\'ve received an email with the topic <strong>QTEST EMAIL</strong>. If not, wait few more minutes, if you still haven\'t got it, <a href="qtest.html">Try again &raquo;</a> sending an email. If the email wouldn\'t get to your mailbox after the second test, try to send it again, but to <strong>another amail address</strong> (preferably from another domain). If the email didn\'t get to the second email address, contact the server administrator, to solve the problem out.</p>' : null );
}
?>